<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonDocument extends Model 
{

    protected $table = 'person_documents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rg', 'rg_dispatcher', 'ctps_number', 'ctps_series', 'ctps_uf', 'cpf', 'cnpj', 'pis_pasep');
    protected $visible = array('rg', 'rg_dispatcher', 'ctps_number', 'ctps_series', 'ctps_uf', 'cpf', 'cnpj', 'pis_pasep');

    public function person()
    {
        return $this->belongsTo('Merchant\Entities\Person', 'person_id', 'id');
    }

}